﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SppExplosionBehaviour : MonoBehaviour {
	private Transform[] parts;
	private Vector3[] originalPosition;
	private Vector3[] explodePosition;
	private const float EXPLOSION_SCALE = 2f;
    private Transform modelRoot;

	public void Explode(float factor) {
        Transform modelContainer = modelRoot.parent;
        Quaternion rotation = modelContainer.rotation;
        Vector3 pos = modelContainer.position;
        modelContainer.rotation = Quaternion.identity;
        modelContainer.position = Vector3.zero;

        for (int i = 0; i < parts.Length; i++) {
            parts[i].localPosition = originalPosition[i] + (explodePosition[i] * factor * EXPLOSION_SCALE); // local
        }
        modelContainer.rotation = rotation;
        modelContainer.position = pos;
    }

    public void Initialize(GameObject root) {
        modelRoot = root.transform;
		int size = root.transform.childCount;
		Bounds modelBounds = SppUtility.GetBoundingBox(root.transform); // world
		Bounds childBounds;
        parts = new Transform[size];
		originalPosition = new Vector3[size];
		explodePosition = new Vector3[size];
		int i = 0;
		foreach (Transform child in root.transform) {
			parts [i] = child;
			childBounds = SppUtility.GetBoundingBox (child); // world
            originalPosition[i] = child.localPosition; // local
            explodePosition[i] = child.InverseTransformPoint(childBounds.center) - child.InverseTransformPoint(modelBounds.center); // local (but convert world bb data in local space)
            i++;
		}	
	}	
}
